# Wizard's Dashboard

**Wizard's Dashboard** is a standalone, self-hosted dashboard manager that connects directly to your database. 
It's designed for flexibility, ease of setup, and full control over your data and deployment.

## Table of Contents

- [Features](#features)
- [Installation Guide](#installation-guide)
    - [Prerequisites](#prerequisites)
    - [Docker Setup Instructions](#docker-setup-instructions)
    - [Non-Docker Setup Instructions](#non-docker-setup-instructions)
- [Integrating with Your Database](#integrating-with-your-database)
    - [Pre-Built Widgets](#pre-built-widgets)
    - [User Table and Login Integration](#user-table-and-login-integration)
- [Getting Started](#getting-started)
- [Support](#support)
- [Production Licensing](#production-licensing)


## Features

- User account management
- Custom widget system
- Multiple dashboard support
- Assign widgets to any dashboard
- Fully self-hosted

## Installation Guide

### Prerequisites
- Web server
- MySQL database
- PHP environment (v7.4+ recommended but not required)

> Need PostgreSQL or another database backend? Let us know—we can usually add support within a day or two.

### Docker Setup Instructions

1. **Download and extract the package**:
    - Download `WizardsDashboard.zip` from:
      ```
      https://WizardsDashboard.com/WizardsDashboard.zip
      ```
    - Extract the contents into an empty directory on your server.

2. **Install using Docker**

   Wizard's Dashboard includes Docker scripts for fast and consistent deployment:
    ```bash
       # Navigate to the installation directory
       cd /path/to/extracted/files
    
       # Start the Docker environment
       ./START.sh
    
       # Set up the MySQL configuration
       ./SETUP_MYSQL.sh
    ```

3. **Complete the setup in your browser** 
    - For local use: http://127.0.0.1/setup.php
    - For production: https://yourdomain.com/setup.php

    Use the setup passcode when prompted: `DashSmart`

    Follow the on-screen instructions to configure database access. A `connect.php` file will be created in the `/wtk` folder upon completion.

   ⚠️ Important: Delete setup.php after confirming your database connection.
   
    After setup, access your dashboard at:
```
http://127.0.0.1/wtkDash.php
```

### Non-Docker Setup Instructions

If you're not using Docker, follow these steps:

1. **Download and extract the package**

    Same as above.

2. **Run database setup manually**
   
    Open `SETUP_MYSQL.sh` to see which SQL scripts to run in your own environment.

3. **Deploy the PHP files**

   Copy the PHP files to your local web server's root directory.

## Integrating with Your Database

### Pre-Built Widgets
Wizard's Dashboard comes with ready-to-use widgets for commonly tracked metrics. These reference the following SQL views:
   - dashUsers
   - dashRevenue
   - dashEmails

You can find these in:
```
/SQL/mySQL/SetupDB/wtk6Views.sql
```

To integrate with your data, modify the views to reference your existing tables instead of the default `wtkUsers`, 
`wtkRevenue`, and `wtkEmailsSent`. The widgets will continue to function without additional modification.

### User Table and Login Integration

Wizard's Dashboard includes a default `wtkUsers` table with built-in support for registration and password recovery. However, you can easily connect it to your own user system. Here are two common approaches:

1. Replace the default user table with a View
   - Create a SQL view named `wtkUsers` that maps to your existing user table.
   - Delete the provided `wtkUsers` table.
   - Update `/wtk/ajxLogin.php` to use your password hashing/validation method.

2. Customize the login logic
   - All access is gated through `/wtk/wtkLogin.php`
   - Modify this file to work with your current authentication system.

> We've done this many times—it's a quick and straightforward process. Reach out for a free consult, and we'll help guide the integration.

## Getting Started

Once you're logged in, you can:

 * Create and manage user accounts
 * Build multiple dashboards for different teams or purposes
 * Create unlimited widgets using simple SQL `SELECT` statements
 * Assign and prioritize widgets per dashboard

### Support

Have questions or need help?

Email us: support@wizardsdashboard.com

## Production Licensing
Wizard's Dashboard includes a license for unlimited local use (localhost or 127.0.0.1).

To deploy on a production domain, purchase a license from:
```
https://WizardsDashboard.com
```
Once purchased, email your domain name to support@wizardsdashboard.com to activate your license.

