#!/usr/bin/env bash

##############################################################################################
#
# This adds data tables and data necessary for Wizard's Dashboard framework
#
###############################################################################################

ask_yes_no() {
    while true; do
        read -p "$1 [y/n]: " yn
        case $yn in
            [Yy]* ) return 0;;
            [Nn]* ) return 1;;
            * ) echo "Please answer yes (y) or no (n).";;
        esac
    done
}

echo
echo "If you are testing locally it is best to have this script create database and set everything up."
echo "If you are preparing for production deployment, it is better to run these scripts manually within your own database."
echo
if ask_yes_no "Do you want to create a new database named wiztools for testing?"; then
    echo
    echo "Creating database, DB user and running scripts to add tables and initial data"
    echo
    echo
else
    # Add your "no" code here
    echo
    echo "You can run the SQL scripts manually in your database."
    echo "This will add the SQL tables and initial setup data for dashboards to work."
    echo "Run all SQL scripts in: SQL/mySQL/SetupDB/ folder in order of 1 through 6"
    echo
    echo
    exit 1
fi

## CREATE DATABASE and USER scripts should only be used for development local testing
docker exec -it dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -e "CREATE DATABASE wiztools;"
docker exec -it dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -e "CREATE USER 'wtkdba'@'localhost' IDENTIFIED BY 'LowCodeViaWTK';"
docker exec -it dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -e "GRANT ALL ON wiztools.* TO 'wtkdba'@'localhost';"

docker exec -it dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -e "CREATE USER 'wtkdba'@'%' IDENTIFIED BY 'LowCodeViaWTK';"
docker exec -it dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -e "GRANT ALL ON wiztools.* TO 'wtkdba'@'%';"

docker exec -it dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -e "FLUSH PRIVILEGES ;"
# Next line may be necessary for some GROUP BY widgets to work
docker exec -it dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -e "SET GLOBAL sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''));"

# Below scripts required for Wizard's Dashboard to work
docker exec -i dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -h 127.0.0.1 wiztools < ./SQL/mySQL/SetupDB/wtk1Tables.sql
docker exec -i dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -h 127.0.0.1 wiztools < ./SQL/mySQL/SetupDB/wtk2Triggers.sql
docker exec -i dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -h 127.0.0.1 wiztools < ./SQL/mySQL/SetupDB/wtk3InitialData.sql
docker exec -i dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -h 127.0.0.1 wiztools < ./SQL/mySQL/SetupDB/wtk4Functions.sql
docker exec -i dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -h 127.0.0.1 wiztools < ./SQL/mySQL/SetupDB/wtk5Procedures.sql
docker exec -i dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -h 127.0.0.1 wiztools < ./SQL/mySQL/SetupDB/wtk6Views.sql

# below 2 lines are only for initial testing; either do not run on production or truncate wtkRevenue after testing is complete
docker exec -i dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -h 127.0.0.1 wiztools < ./SQL/mySQL/Utils/NameGeneration.sql
docker exec -i dash_wtk_db_mysql mysql -uroot -pLowCodeViaWTK -h 127.0.0.1 wiztools < ./SQL/mySQL/Utils/GenerateRevenueData.sql

echo
echo
echo "The database 'wiztools' has been created with Dashboard-related SQL tables and initial data."
echo
echo "Next go to http://127.0.0.1/setup.php"
echo "to verify database connectivity and create your Admin login account."
echo "The page passcode is: DashSmart"
echo