/*
Note in your my.cnf you may want to add these settings:
[mysqld]
skip-log-bin

If you receive errors like this:
which is not functionally dependent on columns in GROUP BY clause; this is incompatible with sql_mode=only_full_group_by

You can fix that by following these steps:

SELECT @@sql_mode;

Then copy the result and remove the ONLY_FULL_GROUP_BY

Then reset the sql_mode variable by pasting in the new values.  Something like this:

SET sql_mode = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION';

# https://stackoverflow.com/questions/41887460/select-list-is-not-in-group-by-clause-and-contains-nonaggregated-column-inc

If you are installing Wizard's Toolkit data files into your own database or want a different DB name, just change
USE wiztools;
... to whatever DB name you want.
*/
-- USE wiztools;

SET FOREIGN_KEY_CHECKS=0;

CREATE TABLE `wtkUsers` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `DelDate` datetime,
  `Title` varchar(40),
  `FirstName` varchar(30),
  `LastName` varchar(35),
  `Address` varchar(45),
  `Address2` varchar(30),
  `City` varchar(30),
  `State` varchar(2),
  `Zipcode` varchar(10),
  `CountryCode` char(2),
  `Phone` varchar(20),
  `CellPhone` varchar(20),
  `PersonalURL` varchar(120),
  `LangPref` char(3),
  `UseSkype` enum('N','Y') default 'N',
  `SMSEnabled` enum('N','Y') default 'N',
  `OptInEmails` enum('N','Y') default 'Y',
  `Email` varchar(80),
  `AltEmail` varchar(80),
  `LoginCode` varchar(40),
  `WebPassword` varchar(255),
  `LoginTimeout` smallint DEFAULT 60,
  `SecurityLevel` smallint DEFAULT 1,
  `StaffRole` varchar(4),
  `MenuSet` varchar(20),
  `CanPrint` enum('N','Y') default 'N',
  `CanExport` enum('N','Y') default 'N',
  `CanEditHelp` enum('N','Y') default 'N',
  `CanUnlock` enum('N','Y') default 'N',
  `SSN` varchar(11),
  `IPAddress` varchar(40),
  `EmailOKDate` datetime,
  `SignedDate` datetime,
  `PromoCode` varchar(24),
  `ExpiresDate` date,
  `FilePath` varchar(30) NULL,
  `NewFileName` varchar(12) NULL,
  `NewPassHash` varchar(140),
  PRIMARY KEY (`UID`),
  KEY `ix_wtkUsers_Email` (`Email`),
  KEY `ix_wtkUsers_LastNameFirstName` (`LastName`, `FirstName`),
  KEY `ix_wtkUsers_FirstNameLastName` (`FirstName`, `LastName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkBugReport` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `CreatedByUserUID` int UNSIGNED DEFAULT NULL,
  `IPaddress` varchar(40),
  `OpSystem` varchar(25),
  `Browser` varchar(20),
  `BrowserVer` varchar(12),
  `AppVersion` varchar(12),
  `DeviceType` enum('computer','tablet','phone') DEFAULT 'computer',
  `ReferralPage` varchar(120),
  `BugMsg` text,
  `InternalNote` varchar(120),
  `DevNote` varchar(255),
  `DevUserUID` int DEFAULT NULL,
  `DoneDate` datetime DEFAULT NULL,
  PRIMARY KEY (`UID`),
  CONSTRAINT `fk_wtkBugReport_CreatedByUserUID`
   FOREIGN KEY (`CreatedByUserUID`) REFERENCES wtkUsers(`UID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkCompanySettings` (
  `UID`     INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate`   timestamp NOT NULL default CURRENT_TIMESTAMP,
  `LastModByUserUID` int UNSIGNED default NULL,
  `CoName`  varchar(120),
  `CoLogo`  varchar(40),
  `CoTagline` VARCHAR(480),
  `Address` varchar(40),
  `City` varchar(40),
  `State` varchar(2),
  `Zipcode` varchar(10),
  `CountryCode` char(2),
  `Phone` varchar(20),
  `Email` varchar(60),
  `MiscContactInfo` text,
  `Ecommerce` varchar(5),
  `PayPalEmail` varchar(60),
  `TaxRate` numeric(6,4),
  `DomainName` varchar(90),
  `StaffWebsite` varchar(90),
  `AppVersion`  varchar(6),
  `EnableLockout` enum('N','Y') NOT NULL DEFAULT 'Y',
  `PreferWYSIWYG` enum('N','Y') NOT NULL DEFAULT 'Y',
  PRIMARY KEY (`UID`),
  CONSTRAINT `fk_wtkCompanySettings_LastModByUserUID`
    FOREIGN KEY (`LastModByUserUID`) REFERENCES wtkUsers(`UID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkEmailTemplate` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `DelDate` datetime,
  `AutomationOnly` enum('N','Y') DEFAULT 'N',
  `EmailType` varchar(8),
  `EmailCode` varchar(20),
  `Subject` varchar(600) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '600 in case of emojis',
  `EmailBody` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `InternalNote` text,
  PRIMARY KEY (`UID`),
  KEY `ix_wtkEmailTemplate_EmailCode` (`EmailCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkEmailsSent` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `EmailUID` int UNSIGNED,
  `EmailType` varchar(8),
  `HtmlTemplate` varchar(30),
  `OtherUID` int UNSIGNED,
  `SendByUserUID` int UNSIGNED,
  `SendToUserUID` int UNSIGNED,
  `EmailAddress` varchar(100),
  `InternalNote` varchar(250),
  `Subject` varchar(600) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '600 in case of emojis',
  `EmailBody` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `EmailMsgId` varchar(200) NULL DEFAULT NULL COMMENT 'used for PostmarkApp and AWS webhooks',
  `EmailDelivered` DATETIME NULL DEFAULT NULL,
  `EmailOpened` DATETIME NULL DEFAULT NULL,
  `EmailLinkClicked` DATETIME NULL DEFAULT NULL,
  `SpamComplaint` DATETIME NULL DEFAULT NULL,
  `Bounced` char(1),
  PRIMARY KEY (`UID`),
  CONSTRAINT `fk_wtkEmailsSent_SendByUserUID`
    FOREIGN KEY (`SendByUserUID`) REFERENCES wtkUsers(`UID`),
  CONSTRAINT `fk_wtkEmailsSent_SendToUserUID`
    FOREIGN KEY (`SendToUserUID`) REFERENCES wtkUsers(`UID`),
  KEY `ix_wtkEmailsSent_EmailType` (`EmailType`,`OtherUID`,`UID`),
  KEY `ix_wtkEmailsSent_EmailMsgId` (`EmailMsgId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkErrorLog` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `UserUID` int UNSIGNED,
  `FromPage` varchar(120),
  `ReferralPage` varchar(120),
  `ErrType` varchar(20),
  `ErrMsg` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `ErrNotes` varchar(100),
  `DevID` varchar(3),
  `DelDate` datetime,
  `LineNum` smallint,
  PRIMARY KEY (`UID`),
  CONSTRAINT `fk_wtkErrorLog_UserUID`
    FOREIGN KEY (`UserUID`) REFERENCES wtkUsers(`UID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkFailedAttempts` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `DelDate` datetime,
  `FailCode` varchar(4) NOT NULL,
  `UserUID` int UNSIGNED,
  `IPaddress` varchar(40),
  `FailNote` varchar(250),
  `OpSystem` varchar(25),
  `Browser` varchar(20),
  `BrowserVer` varchar(12),
  PRIMARY KEY (`UID`),
  CONSTRAINT `fk_wtkFailedAttempts_UserUID`
    FOREIGN KEY (`UserUID`) REFERENCES wtkUsers(`UID`),
  KEY `ix_wtkFailedAttempts_FailCode` (`FailCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkGUID` (
  `GUID` int UNSIGNED NOT NULL auto_increment,
  `TableName` varchar(30),
  PRIMARY KEY (`GUID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkLanguage` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `LastModByUserUID` int UNSIGNED,
  `Language` char(3),
  `MassUpdateId` varchar(30) DEFAULT NULL COMMENT 'JS and HTML prepend lang to id',
  `PrimaryText` varchar(120),
  `NewText` varchar(240),
  PRIMARY KEY (`UID`),
  KEY `ix_wtkLanguage_LastModBy` (`LastModByUserUID`),
  KEY `ix_wtkLanguage` (`PrimaryText`,`Language`),
  KEY `ix_wtkLanguage_MassUpdate` (`MassUpdateId`,`Language`,`PrimaryText`,`NewText`),
  CONSTRAINT `fk_wtkLanguage_LastModByUserUID`
     FOREIGN KEY (`LastModByUserUID`) REFERENCES wtkUsers(`UID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkLockoutUntil` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `FailCode` varchar(4) NOT NULL,
  `UserUID` int UNSIGNED,
  `IPaddress` varchar(40),
  `LockUntil` date,
  `BlockedCount` INT UNSIGNED DEFAULT 0,
  PRIMARY KEY (`UID`),
  KEY `ix_wtkLockoutUntil_IP` (`IPaddress`),
  CONSTRAINT `fk_wtkLockoutUntil_UserUID`
    FOREIGN KEY (`UserUID`) REFERENCES wtkUsers(`UID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkLoginLog` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `UserUID` int UNSIGNED NOT NULL,
  `FirstLogin` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `LastLogin` datetime,
  `LogoutTime` datetime,
  `CurrentPage` varchar(150),
  `PagesVisited` INT UNSIGNED DEFAULT 1,
  `PassedId` INT UNSIGNED NULL,
  `WhichApp` VARCHAR(12),
  `AccessMethod` varchar(15),
  `AppVersion`  varchar(6),
  `apiKey` varchar(256),
  PRIMARY KEY (`UID`),
  CONSTRAINT `fk_wtkLoginLog_UserUID`
    FOREIGN KEY (`UserUID`) REFERENCES wtkUsers(`UID`),
  KEY `ix_LoginLog_apiKey` (`apiKey`),
  KEY `ix_LoginLog_Page` (`CurrentPage`,`PassedId`,`LastLogin`),
  KEY `ix_LoginLog_LastLogin` (`LastLogin`,`UserUID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkLookups` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `DelDate` datetime,
  `LastModByUserUID` int UNSIGNED,
  `LookupType` varchar(15),
  `LookupValue` varchar(40),
  `LookupDisplay` varchar(50),
  `espLookupDisplay` varchar(50),
  PRIMARY KEY (`UID`),
  CONSTRAINT `fk_wtkLookups_LastModByUserUID`
    FOREIGN KEY (`LastModByUserUID`) REFERENCES wtkUsers(`UID`),
  KEY `ix_wtkLookups_LookupType` (`LookupType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkMenuSets` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `DelDate` datetime,
  `MenuName` varchar(20),
  `Description` varchar(120),
  PRIMARY KEY (`UID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkMenuGroups` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `DelDate` datetime,
  `MenuUID` int UNSIGNED NOT NULL,
  `GroupName` varchar(20),
  `GroupURL` varchar(140),
  `Priority` smallint NOT NULL DEFAULT 10,
  PRIMARY KEY (`UID`),
  CONSTRAINT `fk_wtkMenuGroups_MenuUID`
    FOREIGN KEY (`MenuUID`) REFERENCES `wtkMenuSets`(`UID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkMenuItems` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `DelDate` datetime,
  `MenuGroupUID` int UNSIGNED NOT NULL,
  `ShowDividerAbove` enum('N','Y') NOT NULL DEFAULT 'N',
  `PgUID` int UNSIGNED,
  `Priority` smallint NOT NULL DEFAULT 10,
  PRIMARY KEY (`UID`),
  CONSTRAINT `fk_wtkMenuItems_MenuGroupUID`
    FOREIGN KEY (`MenuGroupUID`) REFERENCES `wtkMenuGroups`(`UID`),
  CONSTRAINT `fk_wtkMenuItems_PgUID`
    FOREIGN KEY (`PgUID`) REFERENCES `wtkPages`(`UID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkPages` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `PageName` varchar(200),
  `FileName` varchar(30),
  `Path` varchar(80),
  `DevNote` varchar(250),
  PRIMARY KEY (`UID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkRevenue` (
  `UID`         int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate`     timestamp NOT NULL default CURRENT_TIMESTAMP,
  `UserUID`     int UNSIGNED,
  `OrderUID`    int UNSIGNED,
  `EcomUID`     int UNSIGNED,
  `EcomTxnType` varchar(60),
  `EcomPayId`   varchar(60),
  `AffiliateUID`  int UNSIGNED,
  `AffiliateRate` decimal(5,2),
  `RevType`     varchar(4),
  `IPaddress`   varchar(40),
  `PayerEmail`  varchar(60),
  `PayerId`     varchar(60),
  `FirstName`   varchar(60),
  `LastName`    varchar(60),
  `ItemName`    varchar(120),
  `ItemNumber`  varchar(60),
  `PaymentStatus` varchar(40),
  `GrossAmount`  decimal(7,2),
  `MerchantFee`  decimal(7,2),
  `CurrencyCode` char(3),
  `DevNote`      varchar(50),
  PRIMARY KEY (`UID`),
  INDEX `ix_RevenueAddDate` (`AddDate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkUpdateLog` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `PgUID` int UNSIGNED,
  `UserUID` int UNSIGNED,
  `OtherUID` int UNSIGNED,
  `TableName` varchar(30),
  `FullSQL` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `ChangeInfo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `DevNote` varchar(200),
  PRIMARY KEY (`UID`),
  CONSTRAINT `fk_wtkUpdateLog_UserUID`
    FOREIGN KEY (`UserUID`) REFERENCES wtkUsers(`UID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkUserHistory` (
  `UID` int NOT NULL auto_increment,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `UserUID` int UNSIGNED DEFAULT NULL,
  `OtherUID` int UNSIGNED DEFAULT NULL,
  `PageTitle` varchar(80),
  `PageURL` varchar(150),
  `SecondsTaken` decimal(6,3),
  PRIMARY KEY (`UID`),
  CONSTRAINT `fk_wtkUserHistory_UserUID`
    FOREIGN KEY (`UserUID`) REFERENCES wtkUsers(`UID`),
  KEY `ix_wtkUserHistory_UserUID` (`UserUID`,`UID`),
  KEY `ix_wtkUserHistory_UserUID_PageTitle` (`UserUID`,`PageTitle`),
  KEY `ix_wtkUserHistory_AddDate_UserUID` (`AddDate`,`UserUID`),
  KEY `ix_wtkUserHistory_PageTitle` (`PageTitle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

-- Widget related tables
CREATE TABLE `wtkWidgetGroup` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `DelDate` datetime default NULL,
  `WidgetGroupName` varchar(40),
  `StaffRole` varchar(4),
  `SecurityLevel` smallint DEFAULT 1,
  `UseForDefault` enum('N','Y') default 'N',
  PRIMARY KEY (`UID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkWidget` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `DelDate` datetime default NULL,
  `WidgetName` varchar(40),
  `SecurityLevel` smallint DEFAULT 1,
  `WidgetType` varchar(10),
  `ChartType`  varchar(30),
  `WidgetColor` varchar(20),
  `SkipFooter` enum('N','Y') default 'N',
  `WidgetDescription` varchar(240),
  `WidgetSQL` text,
  `WidgetURL` varchar(80),
  `LinkType` varchar(6),
  `PassRNG` VARCHAR(20),
  `WindowModal` enum('N','Y') default 'N',
  PRIMARY KEY (`UID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkWidgetGroup_X_Widget` (
  `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `AddDate` timestamp NULL default CURRENT_TIMESTAMP,
  `WidgetGroupUID` int UNSIGNED NOT NULL,
  `UserUID` int UNSIGNED default NULL,
  `WidgetUID` int UNSIGNED NOT NULL,
  `WidgetPriority` int NOT NULL DEFAULT 10,
  PRIMARY KEY (`UID`),
  CONSTRAINT `fk_WidgetGroup_X_Widget_WGUID`
    FOREIGN KEY (`WidgetGroupUID`) REFERENCES `wtkWidgetGroup`(`UID`),
  CONSTRAINT `fk_WidgetGroup_X_Widget_UserUID`
    FOREIGN KEY (`UserUID`) REFERENCES `wtkUsers`(`UID`),
  CONSTRAINT `fk_WidgetGroup_X_Widget_WUID`
    FOREIGN KEY (`WidgetUID`) REFERENCES `wtkWidget`(`UID`),
    KEY `ix_wtkWidgetGroup_X_Widget` (`UserUID`,`WidgetGroupUID`,`WidgetPriority`,`WidgetUID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE `wtkUser_X_Dashboards` (
   `UID` int UNSIGNED NOT NULL AUTO_INCREMENT,
   `AddDate` timestamp NULL default CURRENT_TIMESTAMP,
   `UserUID` int UNSIGNED default NULL,
   `WidgetGroupUID` int UNSIGNED NOT NULL,
   `Priority` int NOT NULL DEFAULT 10,
   PRIMARY KEY (`UID`),
   CONSTRAINT `fk_wtkUser_x_Dashboards_UserUID`
       FOREIGN KEY (`UserUID`) REFERENCES `wtkUsers`(`UID`),
   CONSTRAINT `fk_wtkUser_x_Dashboards_WGUID`
       FOREIGN KEY (`WidgetGroupUID`) REFERENCES `wtkWidgetGroup`(`UID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

SET FOREIGN_KEY_CHECKS=1;
