-- USE wiztools;

DROP TRIGGER IF EXISTS `tib_wtkWidgetGroup_X_Widget`;

DELIMITER $$

CREATE TRIGGER `tib_wtkMenuGroups`
    BEFORE INSERT ON `wtkMenuGroups`
    FOR EACH ROW
  BEGIN
    DECLARE fncLastPriority SMALLINT;

    SELECT COUNT(*) INTO fncLastPriority
      FROM `wtkMenuGroups`
    WHERE `MenuUID` = NEW.`MenuUID`;

    IF (fncLastPriority > 0) THEN
        SELECT `Priority` INTO fncLastPriority
          FROM `wtkMenuGroups`
        WHERE `MenuUID` = NEW.`MenuUID`
        ORDER BY `Priority` DESC LIMIT 1;
    END IF;
    SET NEW.`Priority` = (fncLastPriority + 10);
END
$$

CREATE TRIGGER `tib_wtkMenuItems`
    BEFORE INSERT ON `wtkMenuItems`
    FOR EACH ROW
  BEGIN
    DECLARE fncLastPriority SMALLINT;

    SELECT COUNT(*) INTO fncLastPriority
      FROM `wtkMenuItems`
    WHERE `MenuGroupUID` = NEW.`MenuGroupUID`;

    IF (fncLastPriority > 0) THEN
        SELECT `Priority` INTO fncLastPriority
          FROM `wtkMenuItems`
        WHERE `MenuGroupUID` = NEW.`MenuGroupUID`
        ORDER BY `Priority` DESC LIMIT 1;
    END IF;
    SET NEW.`Priority` = (fncLastPriority + 10);
END
$$

CREATE TRIGGER `tib_wtkWidgetGroup_X_Widget`
    BEFORE INSERT ON `wtkWidgetGroup_X_Widget`
    FOR EACH ROW
  BEGIN
    DECLARE  fncLastPriority SMALLINT;

    IF (NEW.`UserUID` IS NULL) THEN
        SELECT COUNT(*) INTO fncLastPriority
          FROM `wtkWidgetGroup_X_Widget`
        WHERE `WidgetGroupUID` = NEW.`WidgetGroupUID` AND `UserUID` IS NULL;
    ELSE
        SELECT COUNT(*) INTO fncLastPriority
          FROM `wtkWidgetGroup_X_Widget`
        WHERE `WidgetGroupUID` = NEW.`WidgetGroupUID` AND `UserUID` = NEW.`UserUID`;
    END IF;

    IF (fncLastPriority > 0) THEN
        IF (NEW.`UserUID` IS NULL) THEN
            SELECT `WidgetPriority` INTO fncLastPriority
              FROM `wtkWidgetGroup_X_Widget`
            WHERE `WidgetGroupUID` = NEW.`WidgetGroupUID` AND `UserUID` IS NULL
            ORDER BY `WidgetPriority` DESC LIMIT 1;
        ELSE
            SELECT `WidgetPriority` INTO fncLastPriority
              FROM `wtkWidgetGroup_X_Widget`
            WHERE `WidgetGroupUID` = NEW.`WidgetGroupUID` AND `UserUID` = NEW.`UserUID`
            ORDER BY `WidgetPriority` DESC LIMIT 1;
        END IF;
    END IF;
    SET NEW.`WidgetPriority` = (fncLastPriority + 10);
END
$$

CREATE TRIGGER `tib_wtkUser_X_Dashboards`
    BEFORE INSERT ON `wtkUser_X_Dashboards`
    FOR EACH ROW
BEGIN
    DECLARE fncLastPriority SMALLINT;

    SELECT COUNT(*) INTO fncLastPriority
    FROM `wtkUser_X_Dashboards`
    WHERE `UserUID` = NEW.`UserUID`;

    IF (fncLastPriority > 0) THEN
        SELECT `Priority` INTO fncLastPriority
        FROM `wtkUser_X_Dashboards`
        WHERE `UserUID` = NEW.`UserUID`
        ORDER BY `Priority` DESC LIMIT 1;
    END IF;
    SET NEW.`Priority` = (fncLastPriority + 10);
END
$$
