-- USE wiztools;

INSERT INTO `wtkCompanySettings` (`CoName`, `DomainName`, `AppVersion`, `EnableLockout`)
 VALUES ('Your Company', 'https://your-company.com', '1.0.0', 'Y');

INSERT INTO `wtkUsers` (`UID`,`DelDate`,`FirstName`,`LastName`,`Address`,`Title`,`Email`,`WebPassword`,`SecurityLevel`,`StaffRole`,`CanPrint`,`CanExport`,`FilePath`,`NewFileName`,`NewPassHash`)
 VALUES (1,NULL,'Your','Name','Some Address', 'Admin', 'admin@email.com', NULL, 99, 'Tech', 'Y', 'Y',NULL,NULL,'needToSet'),
   (2, NOW(), 'Your', 'Server', 'web server', 'Internal Processing', 'server@yourdomain.com', NULL, 99, 'Tech', 'N', 'N',NULL,NULL,NULL);
UPDATE `wtkUsers` SET `UID` = 0 WHERE `UID` = 2;

INSERT INTO `wtkWidgetGroup` (`WidgetGroupName`, `StaffRole`, `SecurityLevel`, `UseForDefault`)
VALUES ('DevOps', 'Tech', 99, 'Y'),
       ('Personal - leave blank, autofilled','Emp', 1, 'N'),
       ('Marketing','Mgr', 30, 'Y');

UPDATE `wtkWidgetGroup` SET `UID` = (`UID` - 1) WHERE `UID` < 4;
ALTER TABLE `wtkWidgetGroup` AUTO_INCREMENT = 3;

INSERT INTO `wtkWidget` (`UID`, `WidgetName`, `SecurityLevel`, `WidgetType`, `ChartType`, `WidgetColor`, `SkipFooter`, `WidgetDescription`, `WidgetSQL`, `WidgetURL`, `LinkType`, `PassRNG`, `WindowModal`)
  VALUES
    (1, 'Users by Security Level', 30, 'List', NULL, NULL, 'Y', NULL, 'SELECT L.`LookupDisplay` AS `SecurityLevel`,\r\n   COUNT(u.`UID`) AS `Count`\r\nFROM `dashUsers` u\r\n  LEFT OUTER JOIN `wtkLookups` L ON L.`LookupType` = \'SecurityLevel\' AND L.`LookupValue` = u.`SecurityLevel`\r\nWHERE u.`DelDate` IS NULL\r\nGROUP BY u.`SecurityLevel`\r\nORDER BY u.`SecurityLevel` ASC', NULL, NULL, NULL, 'N'),
    (2, 'Last 10 Users', 30, 'List', NULL, 'danger-gradient', 'Y', 'Last 10 users that signed up.', 'SELECT CONCAT(COALESCE(`FirstName`,\'\'), \' \', COALESCE(`LastName`,\'\')) AS `User`,\r\n    DATE_FORMAT(`AddDate`, \'%c/%e/%y at %k:%i\') AS `SignedUp`\r\nFROM `dashUsers`\r\nORDER BY `UID` DESC LIMIT 10', NULL, NULL, NULL, 'N'),
    (3, 'New Users - 7 Days', 30, 'Count', NULL, 'info-gradient', NULL, 'how many users signed up in the last 7 days', 'SELECT COUNT(`UID`)\r\nFROM `dashUsers`\r\nWHERE `DelDate` IS NULL AND `AddDate` > (NOW() - INTERVAL 7 DAY)', NULL, NULL, NULL, 'N'),
    (4, 'Revenue Today', 80, 'Count', NULL, 'info-gradient', NULL, NULL, 'SELECT CONCAT(\'$\', FORMAT(COALESCE(SUM(`GrossAmount`), 0),0)) AS `Income`\r\nFROM `dashRevenue`\r\nWHERE DATE_FORMAT(`AddDate`, \'%Y-%m-%d\') = CURRENT_DATE\r\n   AND `PaymentStatus` IN (\'Paid\',\'Authorized\')', NULL, NULL, NULL, 'N'),
    (5, 'Revenue This Week', 80, 'Count', NULL, 'danger-gradient', NULL, 'income from the last 7 days', 'SELECT CONCAT(\'$\', FORMAT(COALESCE(SUM(`GrossAmount`), 0),0)) AS `Income`\r\nFROM `dashRevenue`\r\nWHERE `AddDate` > (CURRENT_DATE - INTERVAL 7 DAY) AND `PaymentStatus` IN (\'Paid\',\'Authorized\')', NULL, NULL, NULL, 'N'),
    (6, 'Revenue This Month', 80, 'Count', NULL, 'success-gradient', NULL, 'income from the last 30 days', 'SELECT CONCAT(\'$\', FORMAT(COALESCE(SUM(`GrossAmount`), 0),0)) AS `Income`\r\nFROM `dashRevenue`\r\nWHERE `AddDate` > (CURRENT_DATE - INTERVAL 30 DAY) AND `PaymentStatus` IN (\'Paid\',\'Authorized\')', NULL, NULL, NULL, 'N'),
    (7, 'Daily Income', 80, 'Chart', 'Line', NULL, NULL, 'last 7 days income summaries', 'SELECT DATE_FORMAT(`AddDate`, \'%b %D (%a)\') AS `Day`,\r\n   COALESCE(SUM(`GrossAmount`), 0) AS `Income`\r\n FROM `dashRevenue`\r\nWHERE `PaymentStatus` IN (\'Paid\', \'Authorized\')\r\nGROUP BY DATE_FORMAT(`AddDate`, \'%Y%j\'), DATE_FORMAT(`AddDate`, \'%b %D (%a)\')\r\nORDER BY DATE_FORMAT(`AddDate`, \'%Y%j\') DESC LIMIT 7', NULL, NULL, NULL, 'N'),
    (8, 'Revenue by Currency Type', 80, 'Chart', 'Pie', 'danger-gradient', NULL, 'income by currency type', 'SELECT `CurrencyCode`, COALESCE(SUM(`GrossAmount`), 0) AS `Income`\r\nFROM `dashRevenue`\r\nWHERE `PaymentStatus` IN (\'Paid\',\'Authorized\')\r\n-- AND `AddDate` > (NOW() - INTERVAL 7 DAY)\r\nGROUP BY `CurrencyCode`\r\nORDER BY SUM(`GrossAmount`) DESC', NULL, NULL, NULL, 'N'),
    (9, 'Activity 1 Day', 80, 'List', NULL, NULL, 'Y', 'Server access statistics', 'call make_widget(1)', NULL, NULL, NULL, 'N'),
    (10, 'Activity 7 Days', 80, 'List', NULL, NULL, 'Y', 'Server access statistics', 'call make_widget(7)', NULL, NULL, NULL, 'N'),
    (11, 'Activity 30 Days', 80, 'List', NULL, NULL, 'Y', 'Server access statistics', 'call make_widget(30)', NULL, NULL, NULL, 'N'),
    (12, 'Update History', 80, 'Chart', 'Bar', NULL, NULL, 'data updates during last 5 days', 'SELECT DATE_FORMAT(`AddDate`, \'%b %D (%a)\') AS `Day`,\r\n    COUNT(`UID`) AS `Count`\r\nFROM `wtkUpdateLog`\r\nGROUP BY DATE_FORMAT(`AddDate`, \'%Y%j\'),DATE_FORMAT(`AddDate`, \'%b %D (%a)\')\r\nORDER BY DATE_FORMAT(`AddDate`, \'%Y%j\') DESC LIMIT 5', NULL, NULL, NULL, 'N'),
    (13, 'Login History', 80, 'Chart', 'Bar', NULL, NULL, 'login activity last 5 days', 'SELECT DATE_FORMAT(`LastLogin`, \'%b %D (%a)\') AS `Day`,\r\n    COUNT(`UID`) AS `Count`\r\n  FROM `wtkLoginLog`\r\nwhere `LastLogin` IS NOT NULL\r\nGROUP BY DATE_FORMAT(`LastLogin`, \'%Y%j\'),DATE_FORMAT(`LastLogin`, \'%b %D (%a)\')\r\nORDER BY DATE_FORMAT(`LastLogin`, \'%Y%j\') DESC LIMIT 5', NULL, NULL, NULL, 'N'),
    (14, 'Page View History', 80, 'Chart', 'Bar', NULL, NULL, 'page views during last 5 days', 'SELECT DATE_FORMAT(`AddDate`, \'%b %D (%a)\') AS `Day`,\r\n    COUNT(`UID`) AS `Count`\r\n  FROM `wtkUserHistory`\r\nGROUP BY DATE_FORMAT(`AddDate`, \'%Y%j\'),DATE_FORMAT(`AddDate`, \'%b %D (%a)\')\r\nORDER BY DATE_FORMAT(`AddDate`, \'%Y%j\') DESC LIMIT 5', NULL, NULL, NULL, 'N'),
    (15, 'Errors Today', 99, 'Count', NULL, 'red-gradient', NULL, 'how many errors in last 24 hours', 'SELECT COUNT(`UID`)\r\n   FROM `wtkErrorLog`\r\n WHERE `DelDate` IS NULL AND `AddDate` > DATE_SUB(NOW(), INTERVAL 1 DAY)', '/mgr/errorLogList', 'SPA', NULL, 'N'),
    (16, 'Active Users', 30, 'Count', NULL, 'danger-gradient', NULL, NULL, 'SELECT COUNT(*) as `Count`\r\nFROM `dashUsers`\r\nWHERE `DelDate` IS NULL', NULL, NULL, NULL, 'N'),
    (17, 'Emails Sent', 50, 'Count', NULL, 'warning-gradient', NULL, 'how many emails sent in the last 24 hours', 'SELECT COUNT(`UID`) AS `Count`\r\nFROM `dashEmails`\r\nWHERE `AddDate` > (NOW() - INTERVAL 1 DAY)', NULL, NULL, NULL, 'N'),
    (18, 'Weekly Income', 80, 'Chart', 'Area', 'danger-gradient', NULL, 'weekly income summaries', 'SELECT DATE_FORMAT(DATE_ADD(`AddDate`, INTERVAL (1 - DAYOFWEEK(`AddDate`)) + 7 DAY), \'%b %D\') AS `WeekEnding`,\r\n   COALESCE(SUM(`GrossAmount`), 0) AS `Income`\r\n FROM `dashRevenue`\r\nWHERE `PaymentStatus` IN (\'Paid\', \'Authorized\')\r\nGROUP BY YEAR(`AddDate`), WEEK(`AddDate`, 1)\r\nORDER BY YEAR(`AddDate`) DESC, WEEK(`AddDate`, 1) DESC LIMIT 7', NULL, NULL, NULL, 'N'),
    (19, 'Update Demo', 30, 'Count', NULL, 'danger-gradient', NULL, 'this is a demo on how can update data from a widget', 'SELECT `Zipcode` FROM `wtkCompanySettings`\r\nWHERE `UID` = 1', 'widgetModal', 'Modal', '1', 'N');

INSERT INTO `wtkWidgetGroup_X_Widget` (`WidgetGroupUID`, `WidgetUID`, `WidgetPriority`)
  VALUES
    (0, 15, 10),
    (0, 16, 20),
    (0, 17, 30),
    (0, 4, 40),
    (0, 13, 50),
    (0, 1, 60),
    (0, 12, 70),
    (0, 9, 80),
    (0, 10, 90),
    (0, 11, 100),
    (0, 19, 110),
    (2, 4, 10),
    (2, 5, 20),
    (2, 6, 30),
    (2, 17, 40),
    (2, 8, 50),
    (2, 7, 60),
    (2, 18, 70);

INSERT INTO `wtkEmailTemplate` (`EmailCode`, `AutomationOnly`, `EmailType`, `Subject`, `EmailBody`, `InternalNote`) VALUES
('invite', 'Y', 'A', 'Welcome to @CompanyName@', '<p>Welcome to our website.</p>\r\n<p>Log in at @website@ using your email and password.</p>\r\n<p>If you do not know your password you can request a password reset on our website.</p>', 'this template is called from the User List by clicking the "Send Invite" button'),
('Welcome', 'Y', 'A', 'Welcome to @CompanyName@', '<p>Welcome to our website.</p>\r\n<p>Thank you for joining our website!</p>', 'this template is called from Registration process'),
('WelcomePIN', 'Y', 'A', 'Welcome to @CompanyName@', '<p>Welcome to our website.</p>\r\n<p>Your PIN is: <span style=\"font-family: \'Courier New\';\"><b>@PIN@</b></span></p>\r\n<p>Thank you for joining our website!</p>', 'this template is called from PIN Registration process'),
('DelAcct', 'Y', 'A', 'Account Deleted', '<h3>Account Deleted</h3>\r\nAs requested, your account has been deleted and all personally identifiable information (PII) has been removed from our database.\r\n\r\nWe are sorry to see you go.  If you ever want to return, simply register a new account at our website at:\r\n@website@\r\n\r\nSincerely,\r\n@CompanyName@', 'automatically sent when user chooses to delete their account'),
('Thank4Order','Y','A','Thank You for Your Order with @CompanyName@', '<p>Hi @FirstName@,</p>\r\n\r\n<p>Thank you for choosing @CompanyName@! We&apos;re thrilled to welcome you to our community and appreciate your trust in our services.</p>\r\n\r\n<h3>Order Details on @Date@</h3>\r\n<p>SKU Number: @SkuNumber@</p>\r\n\r\n<p>Your order is confirmed, and will be delivered shortly. If you have any questions or need assistance, our team is here to help.</p>\r\n\r\n@Param2Str@\r\n\r\n<p>Warm regards,<br>\r\nThe @CompanyName@ Team</p>', 'this will automatically be sent to users if \'Thank4Order\' added in wtkBackgroundActions');

INSERT INTO `wtkPages` (`UID`, `PageName`, `FileName`, `Path`)
  VALUES
(1, 'Settings', 'companyEdit', '/mgr/'),
(2, 'Page List', 'pageList', '/admin/'),
(3, 'Menu Sets', 'menuSetList', '/admin/'),
(4, 'Login Log', 'loginLogList', '/mgr/'),
(5, 'Update Logs', 'updateLogList', '/mgr/'),
(6, 'Error Logs', 'errorLogList', '/mgr/'),
(7, 'WTK Builder', 'wtkBuilder', '/admin/'),
(8, 'Clients', 'clientList', '/admin/'),
(9, 'Ad Tracking', 'adList', '/admin/'),
(10, 'Lookups', 'lookupList', '/admin/'),
(11, 'User History', 'userHistory', '/admin/'),
(12, 'Landing Pages', 'linkList', '/admin/'),
(13, 'Language', 'languageList', '/admin/'),
(14, 'My Profile', 'user', '/wtk/'),
(15, 'Report Wizard', 'reportList', '/admin/'),
(16, 'Users', 'userList', '/mgr/'),
(17, 'Help', 'helpList', '/admin/'),
(18, 'Emails', 'emailTemplates', '/admin/'),
(19, 'Reports Viewer', 'reportViewer', '/wtk/'),
(20, 'Polls', 'polls', '/admin/'),
(21, 'User Edit', 'userEdit', '/wtk/'),
(22, 'Forums', 'forumList', '/wtk/'),
(23, 'Messages', 'messageList', '/wtk/'),
(24, 'Menu Groups', 'menuGroupList', '/admin/'),
(25, 'Emails Sent', 'emailHistory', '/admin/'),
(26, 'Chats', 'chatList', '/wtk/'),
(27, 'Access Fails', 'failedAttemptList', '/admin/'),
(28, 'Broadcast List', 'broadcastList', '/admin/'),
(29, 'Dashboards', 'dashboardList', '/mgr/'),
(30, 'Widgets', 'widgetList', '/mgr/'),
(31, 'Revenue', 'revenueList', '/admin/'),
(32, 'Feedback', 'bugList', '/mgr/'),
(33, 'Visitors', 'visitorStats', '/admin/'),
(34, 'Ecom Providers', 'ecomList', '/admin/'),
(35, 'Money Stats', 'moneyStats', '/admin/'),
(36, 'Affiliates', 'affiliateList', '/admin/'),
(37, 'Prospects', 'prospectList', '/admin/'),
(38, 'Prospect Staff', 'prospectStaffList', '/admin/'),
(39, 'CSV Importer', 'tableColumns', '/mgr/'),
(40, 'History', 'moneyHistory', '/admin/'),
(41, 'Downloads', 'downloadList', '/admin/');

INSERT INTO `wtkMenuSets` (`UID`, `MenuName`, `Description`)
  VALUES (1, 'WTK-Admin', 'administration of Wizards Toolkit');
INSERT INTO `wtkMenuGroups` (`UID`, `MenuUID`, `GroupName`, `GroupURL`)
  VALUES
(1, 1, 'Dashboard', 'dashboard'),
(2, 1, 'Widget Manager', NULL),
(3, 1, 'View Logs', NULL),
(4, 1, 'Logout', 'logout');

INSERT INTO `wtkMenuItems` (`MenuGroupUID`, `ShowDividerAbove`, `PgUID`)
  VALUES
(2, 'N', 30),
(2, 'N', 29),
(2, 'Y', 16),
(2, 'N', 1),
(3, 'N', 4),
(3, 'N', 5),
(3, 'Y', 6),
(3, 'N', 32);

INSERT INTO `wtkLookups` (`LookupType`, `LookupValue`, `LookupDisplay`)
 VALUES
   ('LinkType', 'SPA', 'SPA - Single Page App'),
   ('LinkType', 'Modal', 'Modal Window'),
   ('LinkType', 'MPA', 'Direct Full Link'),
   ('LinkType', 'NewTab', 'Open in new Tab'),

   ('SecurityLevel', '1', 'Customer'),
   ('SecurityLevel', '30', 'Staff'),
   ('SecurityLevel', '50', 'Manager'),
   ('SecurityLevel', '80', 'Director'),
   ('SecurityLevel', '95', 'Owner'),
   ('SecurityLevel', '99', 'Programmer'),
   ('StaffRole', 'Mgr', 'Manager'),
   ('StaffRole', 'Emp', 'Customer Service'),
   ('StaffRole', 'Tech', 'Tech Support'),
   ('FailCode','SQL','SQL Injection'),
   ('FailCode','Hash','PW Reset'),
   ('FailCode','DDOS','DDOS Attack?'),
   ('FailCode','Hack','Hacker Attempt'),
   ('PagePath', '/wtk/', 'WTK'),
   ('PagePath', '/mgr/', 'Manager'),
   ('PagePath', NULL, 'Root'),
   ('YesNoUnknown', 'U', 'Unknown'),
   ('YesNoUnknown', 'Y', 'Yes'),
   ('YesNoUnknown', 'N', 'No'),
   ('LangPref', 'eng', 'English'),
   ('LangPref', 'esp', 'Espa&ntilde;ol'),
   ('EmailHTM', 'emailLight', 'emailLight'),
   ('EmailHTM', 'emailDark', 'emailDark'),
   ('USAstate', 'AL', 'Alabama'),
   ('USAstate', 'AK', 'Alaska'),
   ('USAstate', 'AZ', 'Arizona'),
   ('USAstate', 'AR', 'Arkansas'),
   ('USAstate', 'CA', 'California'),
   ('USAstate', 'CO', 'Colorado'),
   ('USAstate', 'CT', 'Connecticut'),
   ('USAstate', 'DE', 'Delaware'),
   ('USAstate', 'FL', 'Florida'),
   ('USAstate', 'GA', 'Georgia'),
   ('USAstate', 'HI', 'Hawaii'),
   ('USAstate', 'ID', 'Idaho'),
   ('USAstate', 'IL', 'Illinois'),
   ('USAstate', 'IN', 'Indiana'),
   ('USAstate', 'IA', 'Iowa'),
   ('USAstate', 'KS', 'Kansas'),
   ('USAstate', 'KY', 'Kentucky'),
   ('USAstate', 'LA', 'Louisiana'),
   ('USAstate', 'ME', 'Maine'),
   ('USAstate', 'MD', 'Maryland'),
   ('USAstate', 'MA', 'Massachusetts'),
   ('USAstate', 'MI', 'Michigan'),
   ('USAstate', 'MN', 'Minnesota'),
   ('USAstate', 'MS', 'Mississippi'),
   ('USAstate', 'MO', 'Missouri'),
   ('USAstate', 'MT', 'Montana'),
   ('USAstate', 'NE', 'Nebraska'),
   ('USAstate', 'NV', 'Nevada'),
   ('USAstate', 'NH', 'New Hampshire'),
   ('USAstate', 'NJ', 'New Jersey'),
   ('USAstate', 'NM', 'New Mexico'),
   ('USAstate', 'NY', 'New York'),
   ('USAstate', 'NC', 'North Carolina'),
   ('USAstate', 'ND', 'North Dakota'),
   ('USAstate', 'OH', 'Ohio'),
   ('USAstate', 'OK', 'Oklahoma'),
   ('USAstate', 'OR', 'Oregon'),
   ('USAstate', 'PA', 'Pennsylvania'),
   ('USAstate', 'RI', 'Rhode Island'),
   ('USAstate', 'SC', 'South Carolina'),
   ('USAstate', 'SD', 'South Dakota'),
   ('USAstate', 'TN', 'Tennessee'),
   ('USAstate', 'TX', 'Texas'),
   ('USAstate', 'UT', 'Utah'),
   ('USAstate', 'VT', 'Vermont'),
   ('USAstate', 'VA', 'Virginia'),
   ('USAstate', 'WA', 'Washington'),
   ('USAstate', 'WV', 'West Virginia'),
   ('USAstate', 'WI', 'Wisconsin'),
   ('USAstate', 'WY', 'Wyoming'),
   ('Canada', 'AB', 'Alberta'),
   ('Canada', 'BC', 'British Columbia'),
   ('Canada', 'MB', 'Manitoba'),
   ('Canada', 'NB', 'New Brunswick'),
   ('Canada', 'NL', 'Newfoundland and Labrador'),
   ('Canada', 'NT', 'Northwest Territories'),
   ('Canada', 'NS', 'Nova Scotia'),
   ('Canada', 'NU', 'Nunavut'),
   ('Canada', 'ON', 'Ontario'),
   ('Canada', 'PE', 'Prince Edward Island'),
   ('Canada', 'QC', 'Quebec'),
   ('Canada', 'SK', 'Saskatchewan'),
   ('Canada', 'YT', 'Yukon'),
   ('Country','AF','Afghanistan'),
   ('Country','AX','Aland Islands'),
   ('Country','AL','Albania'),
   ('Country','DZ','Algeria'),
   ('Country','AS','American Samoa'),
   ('Country','AD','Andorra'),
   ('Country','AO','Angola'),
   ('Country','AI','Anguilla'),
   ('Country','AQ','Antarctica'),
   ('Country','AG','Antigua and Barbuda'),
   ('Country','AR','Argentina'),
   ('Country','AM','Armenia'),
   ('Country','AW','Aruba'),
   ('Country','AU','Australia'),
   ('Country','AT','Austria'),
   ('Country','AZ','Azerbaijan'),
   ('Country','BS','Bahamas'),
   ('Country','BH','Bahrain'),
   ('Country','BD','Bangladesh'),
   ('Country','BB','Barbados'),
   ('Country','BY','Belarus'),
   ('Country','BE','Belgium'),
   ('Country','BZ','Belize'),
   ('Country','BJ','Benin'),
   ('Country','BM','Bermuda'),
   ('Country','BT','Bhutan'),
   ('Country','BO','Bolivia'),
   ('Country','BA','Bosnia and Herzegovina'),
   ('Country','BW','Botswana'),
   ('Country','BV','Bouvet Island'),
   ('Country','BR','Brazil'),
   ('Country','IO','British Indian Ocean Territory'),
   ('Country','BN','Brunei Darussalam'),
   ('Country','BG','Bulgaria'),
   ('Country','BF','Burkina Faso'),
   ('Country','BI','Burundi'),
   ('Country','KH','Cambodia'),
   ('Country','CM','Cameroon'),
   ('Country','CA','Canada'),
   ('Country','CV','Cape Verde'),
   ('Country','KY','Cayman Islands'),
   ('Country','CF','Central African Republic'),
   ('Country','TD','Chad'),
   ('Country','CL','Chile'),
   ('Country','CN','China'),
   ('Country','CX','Christmas Island'),
   ('Country','C','Cocos (Keeling) Islands'),
   ('Country','CO','Colombia'),
   ('Country','KM','Comoros'),
   ('Country','CG','Congo'),
   ('Country','CD','Congo, Democratic Republic of the'),
   ('Country','CK','Cook Islands'),
   ('Country','CR','Costa Rica'),
   ('Country','CI','Cote D`ivoire'),
   ('Country','HR','Croatia'),
   ('Country','CU','Cuba'),
   ('Country','CY','Cyprus'),
   ('Country','CZ','Czech Republic'),
   ('Country','DK','Denmark'),
   ('Country','DJ','Djibouti'),
   ('Country','DM','Dominica'),
   ('Country','DO','Dominican Republic'),
   ('Country','EC','Ecuador'),
   ('Country','EG','Egypt'),
   ('Country','SV','El Salvador'),
   ('Country','GQ','Equatorial Guinea'),
   ('Country','ER','Eritrea'),
   ('Country','EE','Estonia'),
   ('Country','ET','Ethiopia'),
   ('Country','K','Falkland Islands (Malvinas):'),
   ('Country','FO','Faroe Islands'),
   ('Country','FJ','Fiji'),
   ('Country','FI','Finland'),
   ('Country','FR','France'),
   ('Country','GF','French Guiana'),
   ('Country','PF','French Polynesia'),
   ('Country','TF','French Southern Territories'),
   ('Country','GA','Gabon'),
   ('Country','GM','Gambia'),
   ('Country','GE','Georgia'),
   ('Country','DE','Germany'),
   ('Country','GH','Ghana'),
   ('Country','GI','Gibraltar'),
   ('Country','GR','Greece'),
   ('Country','GL','Greenland'),
   ('Country','GD','Grenada'),
   ('Country','GP','Guadeloupe'),
   ('Country','GU','Guam'),
   ('Country','GT','Guatemala'),
   ('Country','GG','Guernsey'),
   ('Country','GN','Guinea'),
   ('Country','GW','Guinea-Bissau'),
   ('Country','GY','Guyana'),
   ('Country','HT','Haiti'),
   ('Country','HM','Heard Island and Mcdonald Islands'),
   ('Country','A','Holy See (Vatican City State):'),
   ('Country','HN','Honduras'),
   ('Country','HK','Hong Kong'),
   ('Country','HU','Hungary'),
   ('Country','IS','Iceland'),
   ('Country','IN','India'),
   ('Country','ID','Indonesia'),
   ('Country','IR','Iran'),
   ('Country','IQ','Iraq'),
   ('Country','IE','Ireland'),
   ('Country','IM','Isle of Man'),
   ('Country','IL','Israel'),
   ('Country','IT','Italy'),
   ('Country','JM','Jamaica'),
   ('Country','JP','Japan'),
   ('Country','JE','Jersey'),
   ('Country','JO','Jordan'),
   ('Country','KZ','Kazakhstan'),
   ('Country','KE','Kenya'),
   ('Country','KI','Kiribati'),
   ('Country','KP','Korea, Democratic Peoples Republic of'),
   ('Country','KR','Korea, Republic of'),
   ('Country','KW','Kuwait'),
   ('Country','KG','Kyrgyzstan'),
   ('Country','LA','Lao Peoples Democratic Republic'),
   ('Country','LV','Latvia'),
   ('Country','LB','Lebanon'),
   ('Country','LS','Lesotho'),
   ('Country','LR','Liberia'),
   ('Country','LY','Libyan Arab Jamahiriya'),
   ('Country','LI','Liechtenstein'),
   ('Country','LT','Lithuania'),
   ('Country','LU','Luxembourg'),
   ('Country','MO','Macao'),
   ('Country','MK','Macedonia, The Former Yugoslav Republic of'),
   ('Country','MG','Madagascar'),
   ('Country','MW','Malawi'),
   ('Country','MY','Malaysia'),
   ('Country','MV','Maldives'),
   ('Country','ML','Mali'),
   ('Country','MT','Malta'),
   ('Country','MH','Marshall Islands'),
   ('Country','MQ','Martinique'),
   ('Country','MR','Mauritania'),
   ('Country','MU','Mauritius'),
   ('Country','YT','Mayotte'),
   ('Country','MX','Mexico'),
   ('Country','FM','Micronesia, Federated States of'),
   ('Country','MD','Moldova, Republic of'),
   ('Country','MC','Monaco'),
   ('Country','MN','Mongolia'),
   ('Country','ME','Montenegro'),
   ('Country','MS','Montserrat'),
   ('Country','MA','Morocco'),
   ('Country','MZ','Mozambique'),
   ('Country','MM','Myanmar'),
   ('Country','NA','Namibia'),
   ('Country','NR','Nauru'),
   ('Country','NP','Nepal'),
   ('Country','NL','Netherlands'),
   ('Country','AN','Netherlands Antilles'),
   ('Country','NC','New Caledonia'),
   ('Country','NZ','New Zealand'),
   ('Country','NI','Nicaragua'),
   ('Country','NE','Niger'),
   ('Country','NG','Nigeria'),
   ('Country','NU','Niue'),
   ('Country','NF','Norfolk Island'),
   ('Country','MP','Northern Mariana Islands'),
   ('Country','NO','Norway'),
   ('Country','OM','Oman'),
   ('Country','PK','Pakistan'),
   ('Country','PW','Palau'),
   ('Country','PS','Palestinian Territory, Occupied'),
   ('Country','PA','Panama'),
   ('Country','PG','Papua New Guinea'),
   ('Country','PY','Paraguay'),
   ('Country','PE','Peru'),
   ('Country','PH','Philippines'),
   ('Country','PN','Pitcairn'),
   ('Country','PL','Poland'),
   ('Country','PT','Portugal'),
   ('Country','PR','Puerto Rico'),
   ('Country','QA','Qatar'),
   ('Country','RE','Reunion'),
   ('Country','RO','Romania'),
   ('Country','RU','Russian Federation'),
   ('Country','RW','Rwanda'),
   ('Country','BL','Saint Barthelemy'),
   ('Country','SH','Saint Helena'),
   ('Country','KN','Saint Kitts and Nevis'),
   ('Country','LC','Saint Lucia'),
   ('Country','MF','Saint Martin'),
   ('Country','PM','Saint Pierre and Miquelon'),
   ('Country','VC','Saint Vincent and the Grenadines'),
   ('Country','WS','Samoa'),
   ('Country','SM','San Marino'),
   ('Country','ST','Sao Tome and Principe'),
   ('Country','SA','Saudi Arabia'),
   ('Country','SN','Senegal'),
   ('Country','RS','Serbia'),
   ('Country','SC','Seychelles'),
   ('Country','SL','Sierra Leone'),
   ('Country','SG','Singapore'),
   ('Country','SK','Slovakia'),
   ('Country','SI','Slovenia'),
   ('Country','SB','Solomon Islands'),
   ('Country','SO','Somalia'),
   ('Country','ZA','South Africa'),
   ('Country','GS','South Georgia and South Sandwich Islands'),
   ('Country','ES','Spain'),
   ('Country','LK','Sri Lanka'),
   ('Country','SD','Sudan'),
   ('Country','SR','Suriname'),
   ('Country','SJ','Svalbard and Jan Mayen'),
   ('Country','SZ','Swaziland'),
   ('Country','SE','Sweden'),
   ('Country','CH','Switzerland'),
   ('Country','SY','Syrian Arab Republic'),
   ('Country','TW','Taiwan'),
   ('Country','TJ','Tajikistan'),
   ('Country','TZ','Tanzania, United Republic of'),
   ('Country','TH','Thailand'),
   ('Country','TL','Timor-Leste'),
   ('Country','TG','Togo'),
   ('Country','TK','Tokelau'),
   ('Country','TO','Tonga'),
   ('Country','TT','Trinidad and Tobago'),
   ('Country','TN','Tunisia'),
   ('Country','TR','Turkey'),
   ('Country','TM','Turkmenistan'),
   ('Country','TC','Turks and Caicos Islands'),
   ('Country','TV','Tuvalu'),
   ('Country','UG','Uganda'),
   ('Country','UA','Ukraine'),
   ('Country','AE','United Arab Emirates'),
   ('Country','GB','United Kingdom'),
   ('Country','US','United States'),
   ('Country','UM','United States Minor Outlying Islands'),
   ('Country','UY','Uruguay'),
   ('Country','UZ','Uzbekistan'),
   ('Country','VU','Vanuatu'),
   ('Country','VE','Venezuela'),
   ('Country','VN','Viet Nam'),
   ('Country','VG','Virgin Islands, British'),
   ('Country','VI','Virgin Islands, U.S.'),
   ('Country','WF','Wallis and Futuna'),
   ('Country','EH','Western Sahara'),
   ('Country','YE','Yemen'),
   ('Country','ZM','Zambia'),
   ('Country','ZW','Zimbabwe'),
   ('WidgetType','Count','Count'),
   ('WidgetType','Chart','Chart'),
   ('WidgetType','List','List'),
   ('WidgetType','Link','Link'),
   ('WidgetColor','info-gradient','Blue Gradient'),
   ('WidgetColor','success-gradient','Green Gradient'),
   ('WidgetColor','warning-gradient','Orange Gradient'),
   ('WidgetColor','red-gradient','Red Gradient'),
   ('WidgetColor','danger-gradient','Purple-Pink Gradient'),
   ('ChartType','Line','Line'),
   ('ChartType','Area','Area'),
   ('ChartType','Pie','Pie'),
   ('ChartType','Bar','Bar'),
   ('ChartType','All','All');
