-- USE wiztools;

-- MySQL version of PROCEDUREs
DELIMITER $$

-- Usage: call make_widget(1);
-- Used to create widgets showing summary statistics
CREATE PROCEDURE make_widget(fncDays SMALLINT)
BEGIN
    DECLARE fncuid INT DEFAULT 0;

    CREATE TEMPORARY TABLE IF NOT EXISTS tmpResults (
        UID       INT AUTO_INCREMENT PRIMARY KEY,
        tDescrip  VARCHAR(40),
        tCount    INT
    );

    DELETE FROM tmpResults;

    -- Number of Users logged in, Page Views, Updates, Reports Viewed
    INSERT INTO tmpResults (tDescrip, tCount)
        SELECT 'Number of Users logged in', COUNT(DISTINCT UserUID)
        FROM wtkLoginLog
        WHERE LastLogin > (NOW() - INTERVAL fncDays DAY);

    SELECT UID INTO fncuid
    FROM wtkUpdateLog
    WHERE AddDate < (NOW() - INTERVAL fncDays DAY)
    ORDER BY UID DESC
    LIMIT 1;

    INSERT INTO tmpResults (tDescrip, tCount)
        SELECT 'Data Updates', COUNT(UID)
        FROM wtkUpdateLog
        WHERE UID > fncuid;
/*
    SELECT UID INTO fncuid
    FROM wtkReportCntr
    WHERE AddDate < (NOW() - INTERVAL fncDays DAY)
    ORDER BY UID DESC
    LIMIT 1;

    INSERT INTO tmpResults (tDescrip, tCount)
        SELECT 'Reports Viewed', COUNT(UID)
        FROM wtkReportCntr
        WHERE UID > fncuid;
*/
    INSERT INTO tmpResults (tDescrip, tCount)
        SELECT 'Page Views', COUNT(UID)
        FROM wtkUserHistory
        WHERE AddDate > (NOW() - INTERVAL fncDays DAY);

    SELECT tDescrip AS `Description`, tCount AS `Count`
     FROM tmpResults
    ORDER BY UID ASC;

    -- Clean up the temporary table
    DROP TEMPORARY TABLE IF EXISTS tmpResults;
END
$$

DELIMITER ;
