<?PHP
/**
 Add Custom Client functions here to be included in Wizard's Toolkit environment

Can also put in a global search and replace to make sure you do not have cache problems.
For example:
wtkSearchReplace('custom.js','custom4.js');

If you want to globally add wtkPageReadOnlyCheck for all Edit pages you could do it here like:
if (stripos($gloMyPage, 'Edit.php') !== false):
    $gloForceRO = wtkPageReadOnlyCheck($gloMyPage, $gloId);
endif;
*/

/**
* Hard-coded navbar when you do not want to use data-driven menus.
*
* This code is put into ClientFuncs.php because it will likely need to be edited for every website.
*/

/*
* Example usage:
* <code>
* wtkSearchReplace('<!-- @wtkMenu@ -->', wtkNavBar('Your Company Name'));
* </code>
*
* @param string $fncHeader pass this in for the top-center title to show
* @return html of top navbar and side-menu
*/
function wtkNavBarTailwind($fncHeader){
    $fncHtm =<<<htmVAR
<div class="navbar bg-neutral text-neutral-content">
    <div class="navbar-start">
        <div class="dropdown dropdown-hover">
            <div tabindex="0" role="button" class="btn m-1">
                <svg class="wtk-icon"><use href="/imgs/icons.svg#icon-menu"/></svg>
            </div>
            <ul tabindex="0" class="dropdown-content menu min-w-max bg-base-100 text-primary-content p-2 shadow-sm">
                <li><a onclick="Javascript:goHome();document.activeElement.blur()">Dashboard</a></li>
                <li><a onclick="Javascript:ajaxGo('user');document.activeElement.blur()">My Profile</a></li>
                <li><a onclick="Javascript:showBugReport();document.activeElement.blur()">Report Bug</a></li>
                <li><a onclick="Javascript:wtkLogout();document.activeElement.blur();">Log Out</a></li>
            </ul>
        </div>
    </div>
    <div class="navbar-center text-xl">$fncHeader</div>
    <div class="navbar-end">
        <a onclick="wtkLogout();" class="btn btn-ghost btn-circle"><svg class="wtk-icon"><use href="/imgs/icons.svg#icon-logout"></use></svg></a>
    </div>
</div>
htmVAR;
    return $fncHtm;
} // wtkNavBarTailwind
?>
